string GetDescription()
{
	return "This is a very simple instrumental march ( classic military style ) style arrangement.";
}

int GetRandom(int[] @patches)
{
	return patches[RndInt(0, patches.length()-1)];
}

void Arrange(Song @s)
{
	int bars = s.GetBars();	

	if (RndInt(0,3) != 0) s.AddTrack("Drums", 49, 120, 64);
	else s.AddTrack("Drums", 1, 120, 64);
	
	s.AddTrack("Tuba", 59,127,72);
	s.AddTrack("Bass", 64,111,72);
	
	s.AddTrack("Glockenspel", 10,115,80);
	
	s.AddTrack("Picolo", 73,92,30);
	
	s.AddTrack("Trumpet", 57,127,72);
	s.AddTrack("French Horn", 61,120,72);
	
	s.AddTrack("Tuba2", 59,125,59);
	
	
	s.AddRenderEvent("Drums - March", RndInt(0,32000), 0, 0, bars, 1, CreateTime(0,0),1.0); 		
	s.SetParam("foot", ""+1);
	
	s.AddRenderEvent("March Chords", RndInt(0,32000), 1, 0, bars, 0, CreateTime(0,0),1.1); 		
	s.AddRenderEvent("March Bass", RndInt(0,32000), 1, 0, bars, -1, CreateTime(0,0),1.1); 		
	
	
	
	s.AddRenderEvent("March Picolo", RndInt(0,32000), 4, 0, bars, 4, CreateTime(0,0),1.0); 		
	
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		if (s.GetPart(i).GetArrHint() == 0)
		{
			if (RndInt(0,1) == 0)
			{
				s.AddRenderEvent("Drums - March", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 		
				s.SetParam("cymbal", ""+1);	
			}
		}
		else
		{
			if (s.GetPart(i).GetArrHint() == 3)	s.AddRenderEvent("Simple Melody", RndInt(0,32000), 3, s.GetPartStartBar(i), s.GetPartEndBar(i), 3, CreateTime(0,0),1.0); 				
			else s.AddRenderEvent("Simple Melody", RndInt(0,32000), 3, s.GetPartStartBar(i), s.GetPartEndBar(i), 3, CreateTime(0,0),0.7); 				
			
			s.AddRenderEvent("Accented Melody", RndInt(0,32000), 5, s.GetPartStartBar(i), s.GetPartEndBar(i), 0, CreateTime(0,0),1.0); 				
			s.AddRenderEvent("Accented Melody", RndInt(0,32000), 5, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 				
			
			s.AddRenderEvent("Accented Melody", RndInt(0,32000), 6, s.GetPartStartBar(i), s.GetPartEndBar(i), 0, CreateTime(0,0),1.0); 				
			s.AddRenderEvent("Accented Melody", RndInt(0,32000), 6, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 				
		}
		
		if (s.GetPart(i).GetArrHint() == 3)
		{
			s.AddRenderEvent("Drums - March", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 		
			s.SetParam("cymbal", ""+1);
			s.SetParam("snare", ""+1);
			
			s.AddRenderEvent("Random Bass ( Extended )", RndInt(0,32000), 7, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 				
			s.SetParam("mode", ""+1);
			
			s.AddRenderEvent("March Bass", RndInt(0,32000), 2, s.GetPartStartBar(i), s.GetPartEndBar(i), -2, CreateTime(0,0),1.0); 		
		}
		else
		{
			s.AddRenderEvent("March Bass", RndInt(0,32000), 2, s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),1.0); 		
			
			s.AddRenderEvent("Drums - March", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.9); 		
			if (RndInt(0,3) != 0) s.SetParam("snare", ""+1);
			
		}
		
	}
	
	s.AddRenderEvent("Drums - Simple Cymbal", 0, 0, bars-1, bars, 1, CreateTime(1,0),1.0); 		
	
}